﻿/*	Version: 1.1
		1.1		Add "zincFullscreenInit" event,  and "has_zincFullscreenInit" flag
	
	USAGE: 
		#include "functions/zincFullScreen.as"

	EVENTS
		windowScreen				{}		Fires to switch from	fullscreen mode	=>	window mode
		fullScreen					{}		Fires to switch from	window mode			=>	fullscreen mode
		toggleScreen				{}		Fires to toggle between fullscreen mode and window mode
		zincFullscreenInit	{}		Occurs after zincFullScreen.as is available  (Won't occur if fullscreen is impossible)
	
	DESCRIPTION:  This allows toggling 640x480 full-screen mode
		F11 and ALT+Enter toggle between full-screen and window mode
		ESC reverts back to Window mode if you're currently in full-screen mode
*/
// if:  runFunc is missing
if( !runFunc ){
	// then add runFunc()
	if(!_this)		var _this = this;
	function runFunc( func ){
		return func.apply( _this, arguments.slice() );
	}// runFunc()
}// if:  runFunc is missing


#include "functions/eventSystem3.as"
runFunc(function(){
	var key_f11 = 122;
	var key_alt = 18;
	var key_enter = 13;
	var key_esc = 27;
	
	
	
	// CHECK:  Is Zinc available?
	var hasZinc = Boolean( mdm.Exception.DebugWindow.trace !== undefined );
	if( !hasZinc )		return;
	
	
	
	// CHECK:  Is this game running in a 4:3 aspect-ratio?
	var aspectRatio = Stage.height / Stage.width;		// 4:3 = 0.75		(width/height = 1.33333~)  (height/width = 0.75)
	var validAspectRatio = 0.75;
	
	if( aspectRatio !== validAspectRatio )		return;
	
	
	
	// CHECK:  Is 640 x 480 resolution possible?
	var has_640x480 = false;
	var displayModes = mdm.System.getDisplayModes();
	if( !isNaN(displayModes.length) ){
		for(var d=displayModes.length-1; d>=0; d--){
			var thisMode = displayModes[d];
			if( !thisMode[0] )		break;
			
			if( thisMode[0] === 640  &&  thisMode[1] === 480 ){
				has_640x480 = true;
				break;
			}// if:  target resolution found
		}// for each:  display mode
	}// if:  displayModes can be read
	
	if( has_640x480 === false )		return;
	
	
	
	// Initialize react.to
	var _this = _this || this;
	if(!_this.addListener)		AsBroadcaster.initialize( _this );
	if(!react){
		var react = make_react( _this );		// param is optional
		_this.onUnload = function(){
			sendEvent( "unload" );		// this will trigger react.unload()		... and trigger any external code listening for "unload" to occur here
		}// onUnload()
	}// if:  react is missing
	
	
	
	// game window measurements  (border, header)
	var gameWidth = Stage.width;
	var windowWidth = mdm.Forms.MainForm.width;
	var borderSize = Math.floor( (windowWidth - gameWidth)  /  2 );
	var gameHeight = Stage.height;
	var windowHeight = mdm.Forms.MainForm.height;
	var headerSize = (windowHeight - gameHeight) - borderSize;
	
	
	// window positions
	var fullScreenPos = {
		x: -borderSize,		// -8
		y: -headerSize		// -31
	};
	var windowPos = {
		x: mdm.Forms.MainForm.x, 
		y: mdm.Forms.MainForm.y
	};
	
	
	// Can optionally track window position when it's moved by the user
	function onWinDrag( evt ){
		windowPos.x = evt.x;
		windowPos.y = evt.y;
	}// onWinDrag()
	
	

	fscommand( "trapallkeys", true );		// detect all keys instead of "most" keys
	var isFullScreen = false;
	
	
	// toggle between full/window mode
	react.to("toggleScreen").then = function(){
		
		// full-screen => window
		if( isFullScreen === true )
			sendEvent("windowScreen");
			
		// window => full-screen
		else if( isFullScreen === false )
			sendEvent("fullScreen");
			
	}// toggleScreen()
	
	// track window position while in window mode
	mdm.Application.onFormReposition = onWinDrag;
	
	
	// window mode
	react.to("windowScreen").then = function(){
		isFullScreen = false;
		mdm.System.DirectX.disable();
		mdm.Application.restore();
		mdm.Forms.MainForm.x = windowPos.x;
		mdm.Forms.MainForm.y = windowPos.y;
		mdm.Application.onFormReposition = onWinDrag;
	}// windowScreen()
	
	
	// full-screen mode
	react.to("fullScreen").then = function(){
		isFullScreen = true;
		mdm.Application.onFormReposition = null;
		// mdm.Application.maximize();
		mdm.System.DirectX.enable(640, 480, 32);
		mdm.Application.restore();
		mdm.Forms.MainForm.x = fullScreenPos.x;
		mdm.Forms.MainForm.y = fullScreenPos.y;
	}// fullScreen()
	
	
	// Detect key combos
	react.to("onKeyDown").from( Key ).then = function(){
		var keyPressed = Key.getCode();
		
		// F11  =>  toggle
		if( keyPressed === key_f11 )
			sendEvent("toggleScreen");
			
		// ESC  =>  window
		else if( keyPressed === key_esc )
			sendEvent("windowScreen");
	}// key press()
	
	
	// detect ALT+Enter, using polling
	var enter_wasHeld = false;
	var altEnter_loop = setInterval(function(){
		var enter_held = Key.isDown( key_enter );
		var alt_held = Key.isDown( key_alt );
		var enter_press = (enter_held === true  &&  enter_wasHeld === false);
		
		// ALT+Enter  =>  toggle
		if( alt_held  &&  enter_press ){
			sendEvent("toggleScreen");
		}
		
		enter_wasHeld = enter_held;
	}, 33);// loop
	react.to("unload").then = function(){
		clearInterval( altEnter_loop );
	}// unload()
	
	
	// Tell external code that this exists
	// // for the early-birds
	sendEvent("zincFullscreenInit");
	// // for the late-bloomers
	_this.has_zincFullscreenInit = true;
});// private scope